unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, Menus, StdCtrls;

type
  TForm2 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Edit1: TEdit;
    Edit2: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    ListBox1: TListBox;
    MainMenu1: TMainMenu;
    Akcja1: TMenuItem;
    Koniecpracy1: TMenuItem;
    StatusBar1: TStatusBar;
    Edit3: TEdit;
    btnZnajdz: TButton;
    procedure btnZnajdzClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure Wyczylist1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure ListBox1KeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure ListBox1KeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FormCreate(Sender: TObject);
    procedure Koniecpracy1Click(Sender: TObject);

  private
    procedure Info();
    procedure Znajdz();

  public

  end;

var
  Form2: TForm2;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TForm2.btnZnajdzClick(Sender: TObject);
begin
   Znajdz();
end;

procedure TForm2.Button1Click(Sender: TObject);
var
	txt : String;
   idx : Integer;

begin
   txt := '';
   idx := ListBox1.ItemIndex;

   if idx >= 0 then
   begin
      txt := Edit2.Text;
      ListBox1.Items.Strings[idx] := txt;
      Edit2.Text := '';
   end;
end;

procedure TForm2.Button2Click(Sender: TObject);
var
	txt : String;
   idx : Integer;

begin
	txt := '';
   idx := ListBox1.ItemIndex;

   if idx >= 0 then
   begin
      ListBox1.Items.Delete(idx);
   end;
end;

procedure TForm2.Button3Click(Sender: TObject);
begin
   ListBox1.Clear();
end;

procedure TForm2.FormCreate(Sender: TObject);
var
	fn : String;

begin
	Edit1.Text := '';
	Edit2.Text := '';
	Edit3.Text := '';

   fn := ExtractFilePath(Application.ExeName);
   fn := fn + 'woj.txt';

   if FileExists(fn) then
   begin
      ListBox1.Items.LoadFromFile(fn);
   end
   else begin
      ListBox1.Items.Add('Stycze');
      ListBox1.Items.Add('Luty');
      ListBox1.Items.Add('Marzec');
      ListBox1.Items.Add('Kwiecie');
      ListBox1.Items.Add('Maj');
      ListBox1.Items.Add('Czerwiec');
      ListBox1.Items.Add('Lipiec');
      ListBox1.Items.Add('Sierpie');
      ListBox1.Items.Add('Wrzesie');
      ListBox1.Items.Add('Padziernik');
      ListBox1.Items.Add('Listopad');
      ListBox1.Items.Add('Grudzie');
   end;
end;

procedure TForm2.Info();
var
	txt : String;
   idx : Integer;

begin
	txt := '';

   idx := ListBox1.ItemIndex;

   if idx >= 0 then
   begin
      txt := ListBox1.Items.Strings[idx];
      Edit1.Text := txt;
   end
   else begin
      Edit1.Text := '';
   end;
end;

procedure TForm2.Koniecpracy1Click(Sender: TObject);
begin
	if Application.MessageBox('Koniec pracy?', 'Uwaga', MB_YESNO or MB_ICONQUESTION) = mrYes then
   begin
		Close();
   end;
end;

procedure TForm2.ListBox1Click(Sender: TObject);
begin
   Info();
end;

procedure TForm2.ListBox1KeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
	info();
end;

procedure TForm2.ListBox1KeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
	info();
end;

procedure TForm2.Wyczylist1Click(Sender: TObject);
begin
   ListBox1.Clear();
end;

procedure TForm2.Znajdz();
var
	txt : String;
   idx : Integer;

begin
	txt := Trim(Edit3.Text);
   if txt <> '' then
   begin
	   idx := ListBox1.Items.IndexOf(txt);
	   if idx >= 0 then
   	begin
      	ShowMessage('Poszukiwany miesic na pozycji listy: ' + IntToStr(idx));
	   end;
   end;
end;

end.

